﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Content;
using CashierCrisis.Managers;

namespace CashierCrisis.Scenes
{
   

    public abstract class Scene
    {
        public UIManager UIManager { get; set; }



        private SceneManager _sceneManager;
        public SceneManager SceneManager
        {
            get { return _sceneManager; }
            set 
            { 
                _sceneManager = value;
                _content = _sceneManager.Game.Content;
            }
        }

        private ContentManager _content;
        public ContentManager Content
        {
            get { return _content; }
            set { _content = value; }
        }


        public Scene(Game game)
        {
            SceneManager = game.Services.GetService(typeof(SceneManager)) as SceneManager;
            UIManager = game.Services.GetService(typeof(UIManager)) as UIManager;
        }

        public virtual void Draw(SpriteBatch spriteBatch)
        {

        }

        public virtual void Update(GameTime gameTime)
        {

        }

        public virtual void LoadContent()
        {
          
        }

        public virtual void UnloadContent()
        {
        }
    }
}
